package gov.va.med.mhv.admin.service.impl.vastaff;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.mhv.admin.converter.EmployeeConverter;
import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.model.Employee;
import gov.va.med.mhv.admin.repository.EmployeeRepository;
import gov.va.med.mhv.admin.service.vastaff.AdminUserService;
import gov.va.med.mhv.admin.service.vastaff.EmployeeRoleManagementService;
import gov.va.med.mhv.common.api.exception.MHVException;

@Path("/")
@Service("adminUserService")
public class AdminUserServiceImpl implements AdminUserService {

	@Autowired
	private EmployeeRepository employeeRepository;

	@Autowired
	private EmployeeConverter employeeConverter;

	@Autowired
	private EmployeeRoleManagementService employeeRoleManagementService;

	@Override
	@GET
	@Path("/findEmployeeByUserName/{userName}")
	@Produces(MediaType.APPLICATION_JSON)
	public EmployeeDTO findEmployeeByUserName(@PathParam("userName") String employeeUserName) throws MHVException {
		EmployeeDTO employeeDTO = null;
		String userName = null;
		if (employeeUserName != null) {
			userName = employeeUserName.toLowerCase();
		}
		try {
			if (employeeUserName == null) {
				throw new IllegalArgumentException("User Name can not be null");
			}
			Employee employee = employeeRepository.findEmployeeByUserName(userName);
			if (employee != null) {
				employeeDTO = employeeConverter.convert(employee);
			} /*
				 * else{ throw new
				 * MHVException("Employee Not Found for the userName::" +
				 * employeeUserName); }
				 */
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return employeeDTO;
	}

	@Override
	@POST
	// @Path("/saveEmployee/{userName}/{comments}")
	@Path("/saveEmployee")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public EmployeeDTO saveEmployee(EmployeeDTO empDTO)
			throws MHVException {
		EmployeeDTO employeeDTO = null;
		Employee employee = null;
		String empComments = empDTO.getComments();
		try {
			if (empDTO.getUserName() != null) {
				employeeDTO = employeeRoleManagementService.getEmployeeByUserName(empDTO.getUserName());
				if (employeeDTO != null) {
					if (employeeDTO.getEmployeeId() == null) {
						employeeDTO.setOplock(1);
					}
					employeeDTO.setComments(empComments);
					employee = employeeRepository.save(employeeConverter.convert(employeeDTO));
				} else {
					throw new MHVException("Cannot find Employee");
				}
			} else {
				throw new MHVException("EmployeeId cannot be null");
			}

		} catch (MHVException ex) {
			throw ex;
		} catch (Exception e) {
			String message = "Exception Caught saveEmployee";
			e.printStackTrace();
			throw new MHVException(message, e);
		}
		return employeeDTO;
	}
	
	@Override
	@POST
	@Path("/saveLastLoginDt")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public EmployeeDTO saveLastLoginDt(EmployeeDTO employeeDTO)
			throws MHVException {
		Employee employee = null;
		try {
				if (employeeDTO != null) {
					employee = employeeRepository.save(employeeConverter.convert(employeeDTO));
				} else {
					throw new MHVException("Cannot find Employee");
				}
			} 

		catch (MHVException ex) {
			throw ex;
		} catch (Exception e) {
			String message = "Exception Caught saveEmployee";
			e.printStackTrace();
			throw new MHVException(message, e);
		}
		
		return employeeDTO;
	}

}
